using System;
using System.IO;
using System.Text;
using System.Collections.Generic;

class Program
{
    static FastScanner fs = new FastScanner();

    static int N, Q;
    static int[] a;

    static int[] cnt;

    static Fenwick fwCnt, fwSum;

    static void Main()
    {
        N = fs.NextInt();
        Q = fs.NextInt();

        a = new int[N + 1];
        cnt = new int[N + 1];

        for (int i = 1; i <= N; i++)
            a[i] = fs.NextInt();

        fwCnt = new Fenwick(N * N);
        fwSum = new Fenwick(N * N);

        int currentK = 0;
        long totalSum = 0;

        StringBuilder sb = new StringBuilder();

        for (int qi = 0; qi < Q; qi++)
        {
            int t = fs.NextInt();
            if (t == 1)
            {
                int k = fs.NextInt();

                while (currentK < k)
                {
                    currentK++;
                    int v = a[currentK];
                    int old = cnt[v];
                    if (old > 0)
                    {
                        fwCnt.Add(old * v, -1);
                        fwSum.Add(old * v, -(long)old * v);
                        totalSum -= (long)old * v;
                    }
                    cnt[v]++;
                    fwCnt.Add(cnt[v] * v, 1);
                    fwSum.Add(cnt[v] * v, (long)cnt[v] * v);
                    totalSum += (long)cnt[v] * v;
                }

                while (currentK > k)
                {
                    int v = a[currentK];
                    fwCnt.Add(cnt[v] * v, -1);
                    fwSum.Add(cnt[v] * v, -(long)cnt[v] * v);
                    totalSum -= (long)cnt[v] * v;
                    cnt[v]--;
                    if (cnt[v] > 0)
                    {
                        fwCnt.Add(cnt[v] * v, 1);
                        fwSum.Add(cnt[v] * v, (long)cnt[v] * v);
                        totalSum += (long)cnt[v] * v;
                    }
                    currentK--;
                }

                int canRemove = N - k;
                long removed = fwSum.SumTopK(canRemove);
                sb.AppendLine((totalSum - removed).ToString());
            }
            else
            {
                int x = fs.NextInt();
                int y = fs.NextInt();

                if (x <= currentK)
                {
                    int v = a[x];
                    fwCnt.Add(cnt[v] * v, -1);
                    fwSum.Add(cnt[v] * v, -(long)cnt[v] * v);
                    totalSum -= (long)cnt[v] * v;
                    cnt[v]--;

                    if (cnt[v] > 0)
                    {
                        fwCnt.Add(cnt[v] * v, 1);
                        fwSum.Add(cnt[v] * v, (long)cnt[v] * v);
                        totalSum += (long)cnt[v] * v;
                    }

                    v = y;
                    if (cnt[v] > 0)
                    {
                        fwCnt.Add(cnt[v] * v, -1);
                        fwSum.Add(cnt[v] * v, -(long)cnt[v] * v);
                        totalSum -= (long)cnt[v] * v;
                    }
                    cnt[v]++;
                    fwCnt.Add(cnt[v] * v, 1);
                    fwSum.Add(cnt[v] * v, (long)cnt[v] * v);
                    totalSum += (long)cnt[v] * v;
                }

                a[x] = y;
            }
        }

        Console.Write(sb.ToString());
    }
}


class Fenwick
{
    int n;
    long[] f;

    public Fenwick(int n)
    {
        this.n = n;
        f = new long[n + 2];
    }

    public void Add(int i, long v)
    {
        for (; i <= n; i += i & -i)
            f[i] += v;
    }

    public long Sum(int i)
    {
        long s = 0;
        for (; i > 0; i -= i & -i)
            s += f[i];
        return s;
    }

    public long SumTopK(int k)
    {
        long res = 0;
        int pos = n;
        while (k > 0 && pos > 0)
        {
            long cnt = Sum(pos) - Sum(pos - 1);
            if (cnt > 0)
            {
                long take = Math.Min(cnt, k);
                res += take * pos;
                k -= (int)take;
            }
            pos--;
        }
        return res;
    }
}

class FastScanner
{
    byte[] data = new byte[1 << 16];
    int idx, size;
    Stream s = Console.OpenStandardInput();

    public int NextInt()
    {
        int c;
        do
        {
            c = Read();
            if (c == -1) return 0;
        } while (c <= ' ');

        int sign = 1;
        if (c == '-')
        {
            sign = -1;
            c = Read();
        }

        int val = 0;
        while (c > ' ')
        {
            val = val * 10 + (c - '0');
            c = Read();
        }
        return val * sign;
    }

    int Read()
    {
        if (idx >= size)
        {
            size = s.Read(data, 0, data.Length);
            idx = 0;
            if (size == 0) return -1;
        }
        return data[idx++];
    }
}
using System;
using System.IO;
using System.Text;
using System.Collections.Generic;

class Program
{
    static FastScanner fs = new FastScanner();

    static int N, Q;
    static int[] a;

    static int[] cnt;

    static Fenwick fwCnt, fwSum;

    static void Main()
    {
        N = fs.NextInt();
        Q = fs.NextInt();

        a = new int[N + 1];
        cnt = new int[N + 1];

        for (int i = 1; i <= N; i++)
            a[i] = fs.NextInt();

        fwCnt = new Fenwick(N * N);
        fwSum = new Fenwick(N * N);

        int currentK = 0;
        long totalSum = 0;

        StringBuilder sb = new StringBuilder();

        for (int qi = 0; qi < Q; qi++)
        {
            int t = fs.NextInt();
            if (t == 1)
            {
                int k = fs.NextInt();

                while (currentK < k)
                {
                    currentK++;
                    int v = a[currentK];
                    int old = cnt[v];
                    if (old > 0)
                    {
                        fwCnt.Add(old * v, -1);
                        fwSum.Add(old * v, -(long)old * v);
                        totalSum -= (long)old * v;
                    }
                    cnt[v]++;
                    fwCnt.Add(cnt[v] * v, 1);
                    fwSum.Add(cnt[v] * v, (long)cnt[v] * v);
                    totalSum += (long)cnt[v] * v;
                }

                while (currentK > k)
                {
                    int v = a[currentK];
                    fwCnt.Add(cnt[v] * v, -1);
                    fwSum.Add(cnt[v] * v, -(long)cnt[v] * v);
                    totalSum -= (long)cnt[v] * v;
                    cnt[v]--;
                    if (cnt[v] > 0)
                    {
                        fwCnt.Add(cnt[v] * v, 1);
                        fwSum.Add(cnt[v] * v, (long)cnt[v] * v);
                        totalSum += (long)cnt[v] * v;
                    }
                    currentK--;
                }

                int canRemove = N - k;
                long removed = fwSum.SumTopK(canRemove);
                sb.AppendLine((totalSum - removed).ToString());
            }
            else
            {
                int x = fs.NextInt();
                int y = fs.NextInt();

                if (x <= currentK)
                {
                    int v = a[x];
                    fwCnt.Add(cnt[v] * v, -1);
                    fwSum.Add(cnt[v] * v, -(long)cnt[v] * v);
                    totalSum -= (long)cnt[v] * v;
                    cnt[v]--;

                    if (cnt[v] > 0)
                    {
                        fwCnt.Add(cnt[v] * v, 1);
                        fwSum.Add(cnt[v] * v, (long)cnt[v] * v);
                        totalSum += (long)cnt[v] * v;
                    }

                    v = y;
                    if (cnt[v] > 0)
                    {
                        fwCnt.Add(cnt[v] * v, -1);
                        fwSum.Add(cnt[v] * v, -(long)cnt[v] * v);
                        totalSum -= (long)cnt[v] * v;
                    }
                    cnt[v]++;
                    fwCnt.Add(cnt[v] * v, 1);
                    fwSum.Add(cnt[v] * v, (long)cnt[v] * v);
                    totalSum += (long)cnt[v] * v;
                }

                a[x] = y;
            }
        }

        Console.Write(sb.ToString());
    }
}


class Fenwick
{
    int n;
    long[] f;

    public Fenwick(int n)
    {
        this.n = n;
        f = new long[n + 2];
    }

    public void Add(int i, long v)
    {
        for (; i <= n; i += i & -i)
            f[i] += v;
    }

    public long Sum(int i)
    {
        long s = 0;
        for (; i > 0; i -= i & -i)
            s += f[i];
        return s;
    }

    public long SumTopK(int k)
    {
        long res = 0;
        int pos = n;
        while (k > 0 && pos > 0)
        {
            long cnt = Sum(pos) - Sum(pos - 1);
            if (cnt > 0)
            {
                long take = Math.Min(cnt, k);
                res += take * pos;
                k -= (int)take;
            }
            pos--;
        }
        return res;
    }
}

class FastScanner
{
    byte[] data = new byte[1 << 16];
    int idx, size;
    Stream s = Console.OpenStandardInput();

    public int NextInt()
    {
        int c;
        do
        {
            c = Read();
            if (c == -1) return 0;
        } while (c <= ' ');

        int sign = 1;
        if (c == '-')
        {
            sign = -1;
            c = Read();
        }

        int val = 0;
        while (c > ' ')
        {
            val = val * 10 + (c - '0');
            c = Read();
        }
        return val * sign;
    }

    int Read()
    {
        if (idx >= size)
        {
            size = s.Read(data, 0, data.Length);
            idx = 0;
            if (size == 0) return -1;
        }
        return data[idx++];
    }
}